#!/bin/bash
###################################################################
# PlayVideo.sh - Start a video playing using omxplayer            #
#                                                                 #
# The video will play until it is done playing or omxplayer is    #
# stopped.                                                        #
#                                                                 #
###################################################################

# Edit this line to specify the name of the video to play.  The
# video must be a .mp4 file in FPP's videos directory.

MWMFILE="MSEP_dht0009_ESP.txt"
#MWMDELAY in millis
MWMDELAY=850
BAUD=230400
MEDIAFILE="msep.mp3"
#MEDIADELAY in seconds.  decimals for less than 1 sec
MEDIADELAY=1
#TYPE is either music or videos
TYPE="music"

###################################################################
# Set some environment variables
. /opt/fpp/scripts/common

# only allow one show to play at a time
if ! pgrep -x "omxplayer" > /dev/null
then
    sudo  /home/fpp/media/upload/mwmplayer  -d $MWMDELAY  -b $BAUD -f $MWMFILE &
    sleep $MEDIADELAY
    sudo -u fpp /usr/bin/omxplayer --no-keys $MEDIADIR/$TYPE/$MEDIAFILE &
fi