#!/bin/bash
###################################################################
# PlayVideo.sh - Start a video playing using omxplayer            #
#                                                                 #
# The video will play until it is done playing or omxplayer is    #
# stopped.                                                        #
#                                                                 #
###################################################################

# Edit this line to specify the name of the video to play.  The
# video must be a .mp4 file in FPP's videos directory.


#MWMDELAY in millis
MWMDELAY=3500
#BAUD RATE
BAUD=230400
#MwM file to play.  Full path
MWMFILE="jingle_bells.mwm"
#Media file to play.  Full path
MEDIAFILE="Jinglebells360.mp4"
#MEDIADELAY in seconds.  decimals for less than 1 sec
MEDIADELAY=0
#TYPE is either music or videos
TYPE="videos"

###################################################################
# Set some environment variables
. /opt/fpp/scripts/common

# only allow one show to play at a time
if ! pgrep -x "omxplayer" > /dev/null
then
    sudo  /home/fpp/media/upload/mwmplayer  -d $MWMDELAY  -b $BAUD -f $MWMFILE &
    sleep $MEDIADELAY
    sudo -u fpp /usr/bin/omxplayer --no-keys $MEDIADIR/$TYPE/$MEDIAFILE &
fi
