#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <wiringPi.h>
#include <wiringSerial.h>
#include <string.h>

//*************** vars/defs ******************
  
int sp;
FILE *fp;
char buf[255];
char codes[255];
long ShowOffset = -1;
long starttime = -1;


//**************** functions *****************

char* getCodes(char* str) {
  //use the global buffer buf to store the results and set the pointer to it
  char* frag;
  char* colonptr;

  if((colonptr=strchr(str,':'))){  
	frag = colonptr +1;
  }else{
    frag = str;
  }
  
  memcpy(buf,frag,strlen(frag)+1);
  return buf;
}//end of getCodes

long getOffset(char* str) {
  char tstampb[9];
  char *colonptr;
  if((colonptr=strchr(str,':'))){ 
	strncpy(tstampb,str,8);
	tstampb[9]='\0';
    return strtol( tstampb, NULL, 16 );
  } 
  else {
    return -1000;
  }
}

void sendCodes(char* codes){	
  
  serialPuts(sp,codes);
} 

void queue(long offset, char* codes){
   long waitTime;
   if(ShowOffset < 0) ShowOffset = offset;//should cause the recording to start immediately.  probably want to allow input of a showoffset
   if(starttime < 0) starttime = millis();//initialize the start time
   waitTime = offset-ShowOffset;
  
  while(waitTime > millis() - starttime){
	;
  }
  sendCodes(codes);
}

void playFile(FILE *mwmfile){
  char fline[255];
  long offset = -1;
  char* codes; 
  while(fgets(fline,255,mwmfile)){
    offset = getOffset(fline);
    if(offset != -1000){
      codes = getCodes(fline);
	  if(codes[0] != 0){	
		queue(offset,codes);
	  }    
    }
  } 
}//end function

int main(int argc,char *argv[]){
	int i;
	long ms;
	int bd;
	int gotdelay=0;
	int gotbaud=0;
	int gotfile=0;
	
	wiringPiSetup();
	char *endptr;
	char filename[] = "/home/fpp/media/upload/";
	for(i=1;i<argc;i++){
		if(strcmp("-d",argv[i])==0){
		    gotdelay=1;
                    ms = strtol(argv[i+1],&endptr,10);
                    //printf("delay str %s value %ld\n",argv[i+1],ms);
		    delay(ms);
		}
		if(strcmp("-b",argv[i])==0){
			gotbaud=1;
			bd = strtol(argv[i+1],&endptr,10);
			if(bd){
				//sp = serialOpen("/dev/ttyAMA0",(int)bd);//GPIO
				sp = serialOpen("/dev/ttyACM0",(int)bd);
				if(sp == -1){
					sp = serialOpen("/dev/ttyUSB0",(int)bd);
				}
				if(sp == -1){
					printf("couldn't connect to serial\n");
					exit(EXIT_FAILURE);
				}
			}else{
				printf("baud rate invalid\n");
				exit(EXIT_FAILURE);
			}
		}
		if(strcmp("-f",argv[i])==0){
		    //open the file	
			strcat(filename, argv[i+1]);
			fp = fopen(filename,"r");
			if(fp == NULL){
				printf("could not open file %s\n",filename);
				exit(EXIT_FAILURE);
			}
			gotfile=1;
		}		
	}	
	if(gotfile && gotbaud && gotdelay){
		playFile(fp);
		fclose(fp);
	}else{		
		if(!gotfile){
			printf("no filename\nsyntax: mwmplayer -b [baud] -f [filename] -d [delay]\n");
		}
		if(!gotbaud){
			printf("no baud rate\n\nsyntax: mwmplayer -b [baud] -f [filename] -d [delay]\n");
		}
		if(!gotdelay){
			printf("no delay\n\nsyntax: mwmplayer -b [baud] -f [filename] -d [delay]\n");
		}
		exit(EXIT_FAILURE);
	}
	serialClose(sp);
	return(0);
}

//compile cmd:
//gcc -Wall -o mwmplayer mwmplayer4.c -lwiringPi
