#!/bin/bash
###################################################################
# mwmshelltemplate.sh - A template for use with mwmplayer         #
#                                                                 #
###################################################################

# Edit the following to match the files you want to play.  Any
# video must be a .mp4 file uploaded to FPP's videos directory.
# Audio only files need to be mp3 or vorbis ogg format

# Do NOT insert spaces before or after the '=' !

#MWMFILE without full path
MWMFILE=""
#MWMDELAY in millis
MWMDELAY=0
BAUD=230400
MEDIAFILE=""
#MEDIADELAY in seconds.  decimals for less than 1 sec
MEDIADELAY=0
#TYPE is either music or videos
TYPE="videos"

################ Don't make changes below ###########################
# Set some environment variables
. /opt/fpp/scripts/common

# only allow one show to play at a time
if ! pgrep -x "omxplayer" > /dev/null
then
    sudo  /home/fpp/media/upload/mwmplayer  -d $MWMDELAY  -b $BAUD -f $MWMFILE &
    sleep $MEDIADELAY
    sudo -u fpp /usr/bin/omxplayer --no-keys $MEDIADIR/$TYPE/$MEDIAFILE &
fi